# AAA for Management Access

## Overview

- **AAA** (Authentication, Authorization, and Accounting) centralizes and secures administrative access to network devices.
- Local databases are suitable for small environments, but **centralized AAA** is required for scalability and ease of management.
- AAA protocols: **TACACS+** (Cisco proprietary) and **RADIUS** (open standard).

---

## Benefits of Centralized AAA

- Simplifies management of user credentials and access policies across many devices.
- Enables integration with existing authentication systems (Active Directory, LDAP).
- Supports auditing, strong authentication, and role-based access control (RBAC).

---

## AAA Architecture

### Three Security Functions

- **Authentication**
    - Identifies users before granting access.
    - Can use local device databases or external servers (RADIUS, TACACS+, LDAP, AD).
- **Authorization**
    - Determines what authenticated users are allowed to do.
    - Can assign permissions by user, group, or role.
- **Accounting**
    - Tracks user activity for auditing, billing, or reporting.
    - Sends activity logs to centralized servers.

---

## Implementation Approaches

### Local AAA

- Stores user data on each device.
- Not scalable for large deployments.
- Limited support for accounting.

### Centralized AAA

- User credentials and authorization policies managed in a central repository.
- Simplifies policy changes and auditing.
- Often leverages existing user stores like AD or LDAP.

---

## AAA Protocols

### RADIUS

- Open standard protocol, commonly used for network access.
- Combines authentication and authorization in one process.
- Uses UDP (1812 for auth, 1813 for accounting).
- Passwords are obfuscated; other data is sent in cleartext.
- Widely supported on Cisco devices.

### TACACS+

- Cisco proprietary (publicly documented).
- Separates authentication, authorization, and accounting.
- Uses TCP (port 49); encrypts all traffic per session.
- Preferred for device administration and per-command authorization.
- Not supported on all Cisco appliances.

---

## Role-Based Access Control (RBAC)

- **RBAC** limits user access based on job roles, not individual user settings.
- Roles are mapped to specific permissions or command sets.
- Users are assigned to roles, which determine their access rights.

### Implementation on Cisco Devices

#### Cisco IOS XE

- Uses **parser views** to define roles and limit available CLI commands.
- Default 'root' view; up to 15 custom views.

#### Cisco Secure Firewall ASA

- Uses **privilege levels** (0–15) to assign access.
- Predefined roles: Admin (15), Read Only (5), Monitor Only (3).

#### Cisco Secure Firewall Threat Defense, Secure Email Gateway, Secure Web Appliance

- Uses user roles (predefined or custom) for different admin levels.
- User role mapped via group membership in external directories (RADIUS, AD, LDAP).
- Custom roles allow fine-grained control.

---

## AAA Configuration Workflows

### Cisco IOS XE Device (with TACACS+)

1. **Enable AAA globally:**  
    `aaa new-model`
2. **Define TACACS+ server:**  
    `tacacs server ISE`  
    `address ipv4 172.16.10.10`  
    `key SecretKeyString`
3. **Create local user accounts (for backup):**
4. **Set method list for authentication and authorization:**  
    `aaa authentication login default group tacacs+ local`  
    `aaa authorization exec default group tacacs+ local`
5. **Enable per-command authorization:**  
    `aaa authorization commands 15 default group tacacs+ local`
6. **Enable accounting:**  
    `aaa accounting exec default start-stop group tacacs+`  
    `aaa accounting commands 15 default stop-only group tacacs+`

### Cisco Secure Web Appliance (with RADIUS)

1. **Enable external authentication for users.**
2. **Select RADIUS as the authentication type.**
3. **Configure RADIUS server details (hostname, port, secret).**
4. **Configure group mapping for user role assignment (via RADIUS CLASS attribute).**

### Cisco ISE (for user role assignment)

1. **Configure identity groups for user types** (e.g., WSA_ADMIN, WSA_READ_ONLY).
2. **Create authorization profiles** with appropriate RADIUS CLASS attributes.
3. **Create authorization rules** to match identity groups and assign profiles/roles.

---

## TACACS+ Management Access Flow

1. User connects to device and enters credentials.
2. Device forwards credentials to TACACS+ server.
3. TACACS+ server authenticates the user (often via AD/LDAP).
4. Server returns authorization attributes (e.g., privilege level, allowed commands).
5. Device enforces permissions and sends accounting records to server.

---

## RADIUS Management Access Flow

1. User connects to device (e.g., Cisco Secure Web Appliance).
2. Device uses RADIUS to authenticate user (can integrate with AD/LDAP).
3. RADIUS server sends role/class attribute.
4. Device assigns user to appropriate role, controlling available features.

---

## Key Differences: RADIUS vs. TACACS+

|Feature|RADIUS|TACACS+|
|---|---|---|
|Standard|Open|Cisco proprietary|
|Transport|UDP (1812/1813)|TCP (49)|
|Data Encryption|Password only|Full payload|
|Usage|Network access|Device admin|
|Auth & Authz|Combined|Separated|
|Per-command Authz|No|Yes|

---

## Best Practices

- Use centralized AAA for scalable management.
- Integrate with existing user directories (AD/LDAP) when possible.
- Map user groups/roles to device permissions for RBAC.
- Use TACACS+ for administrative device access (per-command authorization).
- Use RADIUS for network access control and appliances supporting role mapping.
- Always enable accounting for auditing and compliance.

---

## Example: Cisco IOS XE AAA TACACS+ Configuration

Copy Code

```none
aaa new-model
tacacs server ISE
 address ipv4 172.16.10.10
 key SecretKeyString
username helpdesk privilege 1 secret hdPass
username adminjr privilege 7 secret jrPass
username adminsr privilege 15 secret srPass
enable secret secretPass
aaa authentication login default group tacacs+ local
aaa authorization exec default group tacacs+ local
aaa authorization commands 15 default group tacacs+ local
aaa accounting exec default start-stop group tacacs+
aaa accounting commands 15 default stop-only group tacacs+ 
```

---

## Notes

- Always configure local fallback user accounts in case the external AAA server is unreachable.
- Custom roles and RBAC mappings should be regularly reviewed and updated to match organizational needs.
- Accounting logs are vital for security audits and compliance requirements.